import "babel-polyfill"
import * as tf from "@tensorflow/tfjs"


class Sess
{
  constructor() { this.load_model() }

  async load_model()
  {
    console.log("[*]模型載入中")
    const startTime = performance.now()
    const MODEL_URL = chrome.extension.getURL('web_model/model.json')
    try
    {
      this.model = await tf.loadGraphModel(MODEL_URL)
      // this.model = await tf.loadLayersModel(MODEL_URL)
      tf.tidy(() => { this.model.predict(tf.zeros([4, 266])) })
      const totalTime = Math.floor(performance.now() - startTime)
      console.log("[*]模型初始化完成，共耗時 " + totalTime + " ms")
    }
    catch
    {
      console.error("[!]無法從下列網址載入模型： " + MODEL_URL)
      return
    }


    const predict = this.predict(this.z_score(this.load_pic()))
    const string = predict.join("")
    console.log("[*]預測驗證碼為：" + string)
    document.querySelector("#baseContent_cph_confirm_txt").value = string
    console.log("[*]已填入驗證碼")
    console.log("[*]執行完畢")
  }

  load_pic()
  {
    return tf.tidy(() =>
    {
      return tf.browser.fromPixels(document.querySelector("#captchaBox > img"), 1)
    })
  }

  z_score(image)
  {
    return tf.tidy(() =>
    {
      var img1 = image.stridedSlice([7, 7], [26, 21], [1, 1]).flatten()
      var moments = tf.moments(img1)
      img1 = img1.sub(moments.mean).div(tf.sqrt(moments.variance)).toInt().toFloat()


      var img2 = image.stridedSlice([7, 21], [26, 35], [1, 1]).flatten()
      moments = tf.moments(img2)
      img2 = img2.sub(moments.mean).div(tf.sqrt(moments.variance)).toInt().toFloat()


      var img3 = image.stridedSlice([7, 34], [26, 48], [1, 1]).flatten()
      moments = tf.moments(img3)
      img3 = img3.sub(moments.mean).div(tf.sqrt(moments.variance)).toInt().toFloat()


      var img4 = image.stridedSlice([7, 48], [26, 62], [1, 1]).flatten()
      moments = tf.moments(img4)
      img4 = img4.sub(moments.mean).div(tf.sqrt(moments.variance)).toInt().toFloat()

      return tf.stack([img1, img2, img3, img4])
    })
  }

  predict(tensor_2d)
  {
    return tf.tidy(() =>
    {
      return this.model.predict(tensor_2d).argMax(1).arraySync()
    })
  }
}

window.addEventListener("load", function()
{
  if(document.querySelector("#captchaBox > img"))
  {
    console.log("[*]已獲取 captchaBox")
    document.querySelector("#baseContent_cph_confirm_txt").value = "####"
    const sess = new Sess();
  }
})
